/******************************************************************************
* This module contains Push Botton Pair type and API definitions.
*
* Copyright (c) 2011, Freescale, Inc.  All rights reserved.
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
******************************************************************************/
#ifndef _PUSHBUTTON__INTERFACE_H_
#define _PUSHBUTTON__INTERFACE_H_


#include "EmbeddedTypes.h" 
#include "NwkInterface.h"
#include "TS_Interface.h" 

/************************************************************************************
*************************************************************************************
* Public macros
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Public type definitions
*************************************************************************************
************************************************************************************/

/* Messages types used for informing the application about confirms or indications 
   arrived trough the PBP SAP */
typedef enum {
  /*---------------------------*/
  gPushButtonPairOrigCnf_c          = 0x00,
  gPushButtonPairRecipCnf_c,
  gPushButtonPairOrigContinueInd_c  = 0x04,  /* backward compatibility */
  gPushButtonPairRecipContinueInd_c = 0x05  /* backward compatibility */
  /*---------------------------*/
}pushButtonToAppMsgType_t;



/* Structure of the PBP to Application SAP messages */


/* PushButtonPair originator procedure */
/*------------------------------------------------------*/
typedef nodeDescriptor_t pushButtonPairOrigContinueInd_t;

typedef nwkNlmePairCnf_t pushButtonPairOrigCnf_t; 




/* PushButtonPair recipient procedure */
/*------------------------------------------------------*/
typedef nwkNlmePairInd_t pushButtonPairRecipContinueInd_t;

typedef nwkNlmePairInd_t pushButtonPairRecipCnf_t;



/* General structure of a message received by the application over PBP SAP */
typedef struct pushButtonToAppMsg_tag 
{
  pushButtonToAppMsgType_t               msgType;
  union {
    /*------------------------------------------------------*/
    pushButtonPairOrigCnf_t          pushButtonPairOrigCnf;
    pushButtonPairRecipCnf_t         pushButtonPairRecipCnf;
    pushButtonPairOrigContinueInd_t  pushButtonPairOrigContinueInd;
    pushButtonPairRecipContinueInd_t pushButtonPairRecipContinueInd;
  } msgData;
}pushButtonToAppMsg_t;


/************************************************************************************
*************************************************************************************
* Public prototypes
*************************************************************************************
************************************************************************************/

 
/************************************************************************************
*************************************************************************************
* Public memory declarations
*************************************************************************************
************************************************************************************/

 /* The Task Id for Profiles */
extern tsTaskID_t gPBPTaskID_c;

/************************************************************************************
*************************************************************************************
* Public functions
*************************************************************************************
************************************************************************************/



/* The Task for Push Button Pair Procedure and Push Button Pair initialization */
extern void PBP_MainTask(event_t events);
extern void PBP_Init(void);

/************************************************************************************
* PBP_InitPushButtonPairOrig
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   None
* 
************************************************************************************/
uint8_t PBP_InitPushButtonPairOrig(void);

/************************************************************************************
* PBP_PushButtonPairOrigRequest
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t PBP_PushButtonPairOrigRequest(
                                              uint16_t          recipPanId, 
                                              uint16_t          recipShortAddress,
                                              uint8_t           recipDeviceType,
                                              appCapabilities_t origAppCapabilities,
                                              uint8_t*          origDeviceTypeList,
                                              uint8_t*          origProfileIdList,
                                              uint8_t           discProfileIdListSize,
                                              uint8_t*          discProfileIdList,
                                              uint8_t           keyExTransferCount,
                                              bool_t            bRequestAppAcceptToPair,
                                              uint16_t          timeToWaitAppAcceptToPair
                                              );
                                              

/************************************************************************************
* PBP_PushButtonPairOrigContinueResponse
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t PBP_PushButtonPairOrigContinueResponse(
                                              bool_t bContinue
                                              );

/************************************************************************************
* PBP_InitPushButtonPairRecip
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t PBP_InitPushButtonPairRecip(void);

/************************************************************************************
* PBP_PushButtonPairRecipRequest
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t PBP_PushButtonPairRecipRequest(
                                              appCapabilities_t origAppCapabilities,
                                              uint8_t*          origDeviceTypeList,
                                              uint8_t*          origProfileIdList,
                                              uint8_t           discLQIThreshold,
                                              bool_t            bRequestAppAcceptToPair,
                                              uint16_t          timeToWaitPairInd,
                                              uint16_t          timeToWaitAppAcceptToPair
                                              );

/************************************************************************************
* PBP_PushButtonPairRecipContinueResponse
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t PBP_PushButtonPairRecipContinueResponse(
                                              bool_t bContinue
                                              );



/************************************************************************************
* PBP_AbortProcess
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
uint8_t PBP_AbortProcess(void);

/************************************************************************************
* PBP_IsIdle
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   Network error code
* 
************************************************************************************/
bool_t PBP_IsIdle(void);

/************************************************************************************
* PBP_HandleNwkNlmeMsg
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   None
* 
************************************************************************************/
void PBP_HandleNwkNlmeMsg(
                          nwkNlmeToAppMsg_t *pMsg
                         );
                                                           
/************************************************************************************
* PBP_APP_SapHandler
*
*
* Interface assumptions:
*   None
*   
* Return value:
*   None
* 
************************************************************************************/
void PBP_APP_SapHandler(
                        pushButtonToAppMsg_t* pushButtonToAppMsg
                       );


#endif  /* _PUSHBUTTON__INTERFACE_H_ */
